<?php
/**
 * SCRIPT DE PRUEBA - DOMAIN MANAGER
 * 
 * Verifica que todos los componentes funcionan
 * Fecha: 2025-11-12
 * Versión: 1.0 Stable
 */

echo "🧪 VERIFICACIÓN DOMAIN MANAGER\n";
echo "=" . str_repeat("=", 40) . "\n\n";

// 1. Verificar archivos
echo "📁 1. Verificando archivos...\n";
echo str_repeat("-", 30) . "\n";

$files = [
    'index.php' => 'Página principal',
    'config.php' => 'Configuración',
    'functions.php' => 'Funciones',
    'auth.php' => 'Autenticación',
    'dashboard.php' => 'Dashboard',
    'database.sql' => 'Base de datos',
    'install.php' => 'Instalador'
];

$allFiles = true;
foreach ($files as $file => $desc) {
    if (file_exists($file)) {
        echo "✅ $desc: $file\n";
    } else {
        echo "❌ $desc: $file [FALTA]\n";
        $allFiles = false;
    }
}

if (!$allFiles) {
    echo "\n❌ ARCHIVOS FALTANTES - Revisar instalación\n";
    exit(1);
}

echo "\n";

// 2. Verificar configuración
echo "⚙️  2. Verificando configuración...\n";
echo str_repeat("-", 30) . "\n";

try {
    require_once 'config.php';
    
    $expectedConfig = [
        'DB_HOST' => 'localhost',
        'DB_NAME' => 'freehosting_domain',
        'DB_USER' => 'freehosting_domain',
        'DB_PASS' => 'freehosting_domain'
    ];
    
    foreach ($expectedConfig as $var => $expected) {
        $actual = constant($var);
        if ($actual === $expected) {
            echo "✅ $var: $actual\n";
        } else {
            echo "⚠️  $var: esperado '$expected', actual '$actual'\n";
        }
    }
    
} catch (Exception $e) {
    echo "❌ Error cargando configuración: " . $e->getMessage() . "\n";
}

echo "\n";

// 3. Verificar funciones
echo "🔧 3. Verificando funciones...\n";
echo str_repeat("-", 30) . "\n";

try {
    require_once 'functions.php';
    
    if (function_exists('getDBConnection')) {
        echo "✅ Función getDBConnection() existe\n";
        
        // Probar conexión
        $pdo = getDBConnection();
        if ($pdo) {
            echo "✅ Conexión a base de datos: OK\n";
            
            // Verificar tablas
            $tables = ['users', 'domains', 'activity_log'];
            foreach ($tables as $table) {
                $stmt = $pdo->query("SHOW TABLES LIKE '$table'");
                if ($stmt->rowCount() > 0) {
                    echo "✅ Tabla '$table': existe\n";
                } else {
                    echo "❌ Tabla '$table': no existe\n";
                }
            }
            
        } else {
            echo "❌ No se pudo conectar a la base de datos\n";
        }
    } else {
        echo "❌ Función getDBConnection() no encontrada\n";
    }
    
} catch (Exception $e) {
    echo "❌ Error: " . $e->getMessage() . "\n";
}

echo "\n";

// 4. Verificar autenticación
echo "🔐 4. Verificando autenticación...\n";
echo str_repeat("-", 30) . "\n";

session_start();
require_once 'auth.php';

if (!isset($_SESSION['user_id'])) {
    echo "❌ Sesión no inicializada\n";
} else {
    echo "✅ Sesión: user_id = " . $_SESSION['user_id'] . "\n";
}

if (!isset($_SESSION['username'])) {
    echo "❌ Username no inicializado\n";
} else {
    echo "✅ Username: " . $_SESSION['username'] . "\n";
}

echo "\n";

// 5. Verificar datos de prueba
echo "📊 5. Verificando datos de prueba...\n";
echo str_repeat("-", 30) . "\n";

try {
    if (isset($pdo)) {
        // Usuario admin
        $stmt = $pdo->prepare("SELECT * FROM users WHERE username = ?");
        $stmt->execute(['admin']);
        $admin = $stmt->fetch();
        
        if ($admin) {
            echo "✅ Usuario admin encontrado\n";
            echo "   📧 Email: " . $admin['email'] . "\n";
            echo "   🏷️  Rol: " . $admin['role'] . "\n";
            echo "   ✅ Estado: " . ($admin['is_active'] ? 'Activo' : 'Inactivo') . "\n";
        } else {
            echo "❌ Usuario admin no encontrado\n";
        }
        
        // Dominios
        $stmt = $pdo->query("SELECT COUNT(*) FROM domains WHERE status = 1");
        $domainsCount = $stmt->fetchColumn();
        echo "🌐 Dominios activos: $domainsCount\n";
        
        if ($domainsCount > 0) {
            $stmt = $pdo->query("SELECT name, extension, expiry_date FROM domains WHERE status = 1 LIMIT 3");
            $domains = $stmt->fetchAll();
            foreach ($domains as $domain) {
                echo "   📋 " . $domain['name'] . '.' . $domain['extension'] . "\n";
            }
        }
    }
    
} catch (Exception $e) {
    echo "❌ Error verificando datos: " . $e->getMessage() . "\n";
}

echo "\n";

// Resultado final
echo "📋 RESUMEN FINAL\n";
echo str_repeat("=", 40) . "\n";

$status = "✅ SISTEMA FUNCIONANDO CORRECTAMENTE";

if (!$allFiles) {
    $status = "❌ ARCHIVOS FALTANTES";
} elseif (!isset($pdo) || !$pdo) {
    $status = "❌ PROBLEMA DE CONEXIÓN A BD";
} elseif (!isset($_SESSION['user_id'])) {
    $status = "❌ PROBLEMA DE AUTENTICACIÓN";
}

echo $status . "\n\n";

if (strpos($status, "✅") === 0) {
    echo "🚀 PRÓXIMOS PASOS:\n";
    echo "1. Acceder a: http://{$_SERVER['HTTP_HOST']}/domain_manager/\n";
    echo "2. Verificar dashboard sin Error 500\n";
    echo "3. Confirmar 'Total Dominios: 1'\n\n";
    
    echo "🔗 URLS DE PRUEBA:\n";
    echo "📊 Dashboard: http://{$_SERVER['HTTP_HOST']}/domain_manager/dashboard.php\n";
    echo "🚀 Instalador: http://{$_SERVER['HTTP_HOST']}/domain_manager/install.php\n";
}

echo "\n🏁 FIN DE LA VERIFICACIÓN\n";
?>