<?php
/**
 * INSTALADOR AUTOMÁTICO - DOMAIN MANAGER
 * 
 * Instala y configura el sistema automáticamente
 * Fecha: 2025-11-12
 * Versión: 1.0 Stable
 */

echo "🚀 INSTALADOR DOMAIN MANAGER\n";
echo "=" . str_repeat("=", 40) . "\n\n";

// Configuración MySQL (como solicitaste)
$config = [
    'host' => 'localhost',
    'database' => 'freehosting_domain',
    'username' => 'freehosting_domain',
    'password' => 'freehosting_domain'
];

echo "📋 Configuración de MySQL:\n";
echo "   🏠 Host: {$config['host']}\n";
echo "   🗄️  Base de datos: {$config['database']}\n";
echo "   👤 Usuario: {$config['username']}\n";
echo "   🔑 Contraseña: {$config['password']}\n\n";

// Paso 1: Crear base de datos y tablas
echo "📋 Paso 1: Creando base de datos...\n";
echo str_repeat("-", 40) . "\n";

try {
    // Conectar como root para crear BD
    $pdoRoot = new PDO(
        "mysql:host={$config['host']};charset=utf8",
        'root',
        '',
        [PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION]
    );
    
    // Crear base de datos
    $pdoRoot->exec("CREATE DATABASE IF NOT EXISTS `{$config['database']}` CHARACTER SET utf8 COLLATE utf8_general_ci");
    echo "✅ Base de datos '{$config['database']}' creada\n";
    
    // Conectar a la nueva base de datos
    $pdo = new PDO(
        "mysql:host={$config['host']};dbname={$config['database']};charset=utf8",
        $config['username'],
        $config['password'],
        [PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION]
    );
    
    // Ejecutar SQL del archivo
    $sqlFile = __DIR__ . '/database.sql';
    if (!file_exists($sqlFile)) {
        throw new Exception("database.sql no encontrado");
    }
    
    $sql = file_get_contents($sqlFile);
    
    // Separar y ejecutar comandos SQL
    $statements = array_filter(
        array_map('trim', explode(';', $sql)),
        function($stmt) { 
            return !empty($stmt) && !preg_match('/^--/', $stmt); 
        }
    );
    
    foreach ($statements as $statement) {
        if (!empty(trim($statement))) {
            try {
                $pdo->exec($statement);
            } catch (PDOException $e) {
                if (strpos($e->getMessage(), 'already exists') === false) {
                    echo "⚠️  Advertencia: " . substr($e->getMessage(), 0, 80) . "...\n";
                }
            }
        }
    }
    
    echo "✅ Tablas creadas correctamente\n";
    
} catch (Exception $e) {
    echo "❌ Error: " . $e->getMessage() . "\n\n";
    echo "🔧 Soluciones:\n";
    echo "1. Verificar que MySQL está ejecutándose\n";
    echo "2. Verificar credenciales en config.php\n";
    echo "3. Crear usuario '{$config['username']}' manualmente\n";
    exit(1);
}

echo "\n";

// Paso 2: Verificar instalación
echo "🔍 Paso 2: Verificando instalación...\n";
echo str_repeat("-", 40) . "\n";

try {
    // Verificar conexión
    $pdo = getDBConnection();
    echo "✅ Conexión a base de datos: OK\n";
    
    // Verificar tablas
    $tables = ['users', 'domains', 'activity_log'];
    foreach ($tables as $table) {
        $stmt = $pdo->query("SHOW TABLES LIKE '$table'");
        if ($stmt->rowCount() > 0) {
            echo "✅ Tabla '$table': OK\n";
        } else {
            echo "❌ Tabla '$table': FALTA\n";
        }
    }
    
    // Verificar datos
    $stmt = $pdo->query("SELECT COUNT(*) FROM users");
    $usersCount = $stmt->fetchColumn();
    echo "👥 Usuarios: $usersCount\n";
    
    $stmt = $pdo->query("SELECT COUNT(*) FROM domains WHERE status = 1");
    $domainsCount = $stmt->fetchColumn();
    echo "🌐 Dominios activos: $domainsCount\n";
    
    if ($domainsCount == 0) {
        // Agregar dominio de prueba
        $stmt = $pdo->prepare("INSERT INTO domains (name, extension, registrar, registration_date, expiry_date, status) VALUES (?, ?, ?, ?, ?, ?)");
        $stmt->execute(['sas', 'com', 'Test Registrar', '2024-01-01', '2025-12-31', 1]);
        echo "✅ Dominio de prueba agregado: sas.com\n";
    }
    
} catch (Exception $e) {
    echo "❌ Error en verificación: " . $e->getMessage() . "\n";
}

echo "\n";

// Resultado final
echo "🎉 INSTALACIÓN COMPLETADA\n";
echo str_repeat("=", 40) . "\n\n";

echo "📋 INFORMACIÓN DE ACCESO:\n";
echo "🌐 URL: " . (isset($_SERVER['HTTPS']) ? 'https' : 'http') . "://{$_SERVER['HTTP_HOST']}/domain_manager/\n";
echo "👤 Usuario: admin\n";
echo "🔑 Contraseña: password\n";
echo "📊 Dominio de prueba: sas.com\n\n";

echo "🧪 PRUEBAS:\n";
echo "1. Acceder a la URL principal\n";
echo "2. Verificar que muestra 'Total Dominios: 1'\n";
echo "3. Confirmar que no hay Error 500\n\n";

echo "⚠️  IMPORTANTE:\n";
echo "- El dashboard está en dashboard.php\n";
echo "- index.php redirige automáticamente\n";
echo "- Verificar que todos los archivos están subidos\n\n";

echo "✅ ¡Sistema listo para usar!\n";
?>